<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\Admin\AlbumRepository;
use App\Repositories\Admin\ArtistRepository;

use App\Artist;

class AlbumController extends Controller
{
    public function __construct(AlbumRepository $albumRepository, ArtistRepository $artistRepository)
    {
        $this->albumRepository = $albumRepository;
        $this->artistRepository = $artistRepository;

        $this->perPage = 15;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $albums = $this->albumRepository->getPaginated($this->perPage);

        // dd($album);
        return view('albums.index', compact('albums'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $artists = $this->albumRepository->getArtist();
        return view('albums.create',compact('artists'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $request->validate([
            'album_name_en' => 'required',
            'album_name_mm' => 'required',
            'album_image' => 'required',
        ]);
        // dd($request->all());

        $this->albumRepository->createAlbum($request->all());
      
        return redirect()->route('album.index')->with(['status'=>'Created successfully.']);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request)
    {
        // dd(request()->id);
        $album = $this->albumRepository->getById(request()->id);
        $artists = $this->albumRepository->getArtist();

        return view('albums.edit', compact('album','artists'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {

        $request->validate([
            'album_name_en' => 'required',
            'album_name_mm' => 'required',
            // 'album_image' => 'required',
        ]);
         
        $update = ['album_name_en' => $request->album_name_en, 'album_name_mm' => $request->album_name_mm,
        'artist_id' => $request->artist_id]; 
      
        if ($files = $request->file('album_image')) {
            $destinationPath = 'public/images/'; // upload path
            $profileImage = date('YmdHis') . "." . $files->getClientOriginalExtension();
            $files->move($destinationPath, $profileImage);
            $update['album_image'] = url('/')."/public/images/"."$profileImage";
         }

      

        $this->albumRepository->updateAlbum($request->id, $update);
            
        return redirect()->route('album.index')->with(['status'=>'Updated successfully.']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $this->albumRepository->delete($request->id);
        return redirect()->route('album.index')->with(['status'=>'Deleted successfully']);
    }
}
