@extends('adminlte::page')
@section('content')
        <div class="content-header">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="text-dark">Add Album</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item">
                            <a href="#">Home</a>
                        </li>
                        <li class="breadcrumb-item active">
                            <a href="{{route('album.index')}}">Album List</a>
                        </li>
                        <li class="breadcrumb-item active">
                            <a href="{{route('album.create')}}">Add Album</a>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="card">
            
            <!-- The Form to Add a New Album -->
            {!! Form::open(['route'=>'album.save','method'=>'POST','id'=>'create_album','enctype' => 'multipart/form-data']) !!}
                <div class="card-body">
                    <div class="col-12">
                        <div class="row">
                            <div class="col-6">
                                <div class="form-group">
                                    <label for="artists">Artist</label>
                                    <select class="form-control select2bs4" name="artist_id" required>
                                            <option  value="" >Select Artist</option>
                                        @foreach ($artists as $key => $val)
                                            <option value="{{ $key }}">{{ $val }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-group">
                                    <label for="album_name_en">Album Name EN</label>
                                    <input class="form-control" name="album_name_en" type="text"  required> 
                                </div>
                            </div>
                           
                        </div>
                        <div class="row">
                            <div class="col-6">
                                <div class="form-group">
                                    <label for="album_name_mm">Album Name MM</label>
                                    <input class="form-control" name="album_name_mm" type="text"  required> 
                                </div>
                            </div>
                            <div class="col-6">
                                <label for="imageInput">Album Image</label>
                                <div class="form-group">
                                    <input data-preview="#preview" name="album_image" type="file" id="imageInput" required> 
                                </div>
                            </div>
                           
                        </div>
                    </div>
                    <div class="col-12">
                        <a href="{{route('album.index')}}" class="btn btn-default">
                            <i class="fas fa-reply-all"></i> Back
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="far fa-save"></i> Save
                        </button>
                    </div>
                </div>
            {!! Form::close() !!}
        </div>
    
@endsection
@section('adminlte_js')
<script>
  
    /*For form Validation*/
    jQuery( document ).ready(function( $ ) {

        $('#create_township').validate({ // initialize the plugin
                ignore: [],
                errorElement: "span",
                errorClass: "error-help-block",
                rules: {
                    name: {
                        required: true,
                        maxlength: 100
                    },
                    zone_id:{
                        required: true,
                    },
                    
                },
        });

    });
   
</script>
@stop