@extends('adminlte::page')
@section('content')

            <div class="content-header">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="text-dark">Update Artist</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item">
                                <a href="#">Home</a>
                            </li>
                            <li class="breadcrumb-item active">
                                <a href="{{route('artist.index')}}">Artist List</a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="#">Update Artist</a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
            <div class="card">
              
                {!! Form::open(['route'=>'artist.update','method'=>'POST','id'=>'update_artist','enctype' => 'multipart/form-data']) !!}
                    {!! Form::hidden('id', $artist->id) !!}
                    <div class="card-body">
                        <div class="col-12">
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group">
                                        {{ Form::label('name','Name EN',array('class'=>'control-label'))}}
                                        {{ Form::text('name_en',$artist->name_en,array('class'=>'form-control')) }}
                                    </div>
                                </div>
                                <div class="col-6">
                                <div class="form-group">
                                        {{ Form::label('name','Name MM',array('class'=>'control-label'))}}
                                        {{ Form::text('name_mm',$artist->name_mm,array('class'=>'form-control')) }}
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-3">
                                    <div class="form-group">
                                        {{ Form::label('image','Profile Image',array('class'=>'control-label'))}}
                                        <div class="row">
                                            <input class="col-md-6"  name="image" type="file"  value="{{$artist->image}}">
                                            <div class="col-md-6">
                                                <img class="img-circle img-lg" id="preview"  src="{{$artist->image}}">
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="col-3">
                                    <div class="form-group">
                                        {{ Form::label('image','Cover Image',array('class'=>'control-label'))}}
                                        <div class="row">
                                            <input class="col-md-6"  name="cover_image" type="file"  value="{{$artist->cover_image}}">
                                            <div class="col-md-6">
                                                <img class="img-circle img-lg" id="preview"  src="{{$artist->cover_image}}">
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="col-6">
                                <div class="form-group">
                                        {{ Form::label('gender','Gender',array('class'=>'control-label'))}}
                                        <div class="form-group">
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="gender"  value="male" @if($artist->gender =="male") checked @endif required>
                                                <label class="form-check-label" for="gender">
                                                    Male
                                                </label>
                                                &nbsp; &nbsp; &nbsp;
                                                <input class="form-check-input" type="radio" name="gender"  value="female" @if($artist->gender =="female") checked @endif required>
                                                <label class="form-check-label" for="gender">
                                                    Female
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <a href="{{route('artist.index')}}" class="btn btn-default">
                                <i class="fas fa-reply-all"></i> Back
                            </a>
                                   
                            <button type="submit" class="btn btn-primary">
                                <i class="far fa-save"></i> Update
                            </button>
                                 
                         
                        </div>
                    </div>
                {!! Form::close() !!}
            </div>
            
       
@stop
@section('adminlte_js')
<script>

     /* For Form Validation */
    jQuery( document ).ready(function( $ ) {

        $('#create_township').validate({ // initialize the plugin
                ignore: [],
                errorElement: "span",
                errorClass: "error-help-block",
                rules: {
                    name: {
                        required: true,
                        maxlength: 100
                    },
                    zone_id:{
                        required: true,
                    },
                    
                },
        });

    });
   
</script>
@stop