@extends('adminlte::page')

@section('content')
            <div class="content-header">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="text-dark">Update User</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item">
                                <a href="#">Home</a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="{{route('users.index')}}">User List</a>
                            </li>
                            <li class="breadcrumb-item active">
                                <a href="{{url('control-panel/users/edit?id='.$user->id)}}">Update User</a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
            <div class="card">
              

                <div class="card-body">

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif

                    <div id="tasks">
                        <!-- The Form to Add a New Task -->

                        {!! Form::open(['route'=>'users.update','method'=>'POST','id'=>'create_user']) !!}
                            {{ csrf_field() }}
                            {{ Form::hidden('id', $user->id) }}
                            <div class="form-group">
                                <div class="row">

                                    <div class="col-2">
                                        {{ Form::label('name','User Name',array('class'=>'control-label'))}}
                                    </div>
                                    <div class="col-10">
                                        {{ Form::text('name',$user->name,array('class'=>'form-control','placeholder'=>'Enter Name')) }}
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="row">
                                    <div class="col-2">
                                        {{ Form::label('email','Email',array('class'=>'control-label'))}}
                                    </div>
                                    <div class="col-10">
                                        {{ Form::email('email',$user->email,array('class'=>'form-control','placeholder'=>'Enter Email')) }}
                                    </div>
                                </div>

                            </div>

                            <div class="form-group">
                                <div class="row">
                                    <div class="col-2">
                                        {{ Form::label('role_id','Role',array('class'=>'control-label'))}}
                                    </div>
                                    <div class="col-10">
                                        
                                        {{ Form::select('role_id',$roles,$user->role_id,array('class'=>'form-control','placeholder'=>'<--Select Role-->')) }}
                                    </div>
                                </div>

                            </div>


                            <div class="col-12">
                                
                                <a href="{{route('users.index')}}" class="btn btn-default back-btn">
                                    <i class="fas fa-reply-all"></i> Back
                                </a>
                                <button type="submit" class="btn btn-primary">
                                    <i class="far fa-save"></i> Save
                                </button>
                                        
                            </div>


                        {!! Form::close() !!}



                    </div>

                </div>
            </div>
       
@endsection
@section('adminlte_js')
<script>
    jQuery( document ).ready(function( $ ) {

        $('#create_user').validate({ // initialize the plugin
                ignore: [],
                errorElement: "span",
                errorClass: "error-help-block",
                rules: {
                    name: {
                        required: true,
                        maxlength: 100
                    },
                    email:{
                        required: true,
                        email: true,
                    },
                    role_id:{
                        required: true,
                    },
                    
                    
                },
        });

    });
   
</script>
@stop
