@extends('adminlte::page')
@section('content')
            <div class="content-header">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="text-dark">Add Artist</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item">
                                <a href="#">Home</a>
                            </li>
                            <li class="breadcrumb-item active">
                                <a href="{{route('zone.index')}}">Artist List</a>
                            </li>
                            <li class="breadcrumb-item active">
                                <a href="{{route('zone.create')}}">Add Artist</a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
         
            <div class="card">
               
                {!! Form::open(['route'=>'zone.save','method'=>'POST','id'=>'create_zone']) !!}
                    <div class="card-body">
                        
                        <!-- The Form to Add a New Zone -->
                        <div class="col-12">
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group">
                                        {{ Form::label('zone_name','Artist Name',array('class'=>'control-label'))}}
                                        {{ Form::text('zone_name','',array('class'=>'form-control')) }}
                                    </div>
                                </div>
                                
                            </div>
                        </div>
                       
                        <div class="col-12">
                            <a href="{{route('zone.index')}}" class="btn btn-default">
                                <i class="fas fa-reply-all"></i> Back
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="far fa-save"></i> Save
                          
                         </div>
  
                    </div>
                {!! Form::close() !!}
            </div>
        
@endsection
@section('adminlte_js')
<script>
   
  
    //for form validation
    jQuery( document ).ready(function( $ ) {

        $('#create_zone').validate({ // initialize the plugin
                ignore: [],
                errorElement: "span",
                errorClass: "error-help-block",
                rules: {
                    zone_name: {
                        required: true,
                        maxlength: 100
                    },
                    url:{
                        required: true,
                    },
                    
                    fetch_name: {
                        required: true,
                    }
                },
        });

    });
   
    $("#togBtn").on('change', function() {
        if ($(this).is(':checked')) {
            $(this).val('1');

        }
        else {
            $(this).val('0');
        }
    });
</script>
@stop