@extends('adminlte::page')
@section('content') 
            <div class="content-header">
                    <div class="row mb-2">
                        <div class="col-sm-6">
                            <h1 class="text-dark">Artist List</h1>
                        </div>
                        <div class="col-sm-6">
                            <ol class="breadcrumb float-sm-right">
                                <li class="breadcrumb-item">
                                    <a href="#">Home</a>
                                </li>
                                <li class="breadcrumb-item active">
                                    <a href="{{route('zone.index')}}">Artist List</a>
                                </li>
                            </ol>
                        </div>
                    </div>
            </div>
            @if (session('status'))
                <div class="alert alert-success" role="alert" id="dialog">
                    {{ session('status') }}
                </div>
            @endif
            @if (session('error'))
                <div class="alert alert-danger" role="alert" id="errordialog">
                    {{ session('error') }}
                </div>
            @endif

            <div class="card">
                
                <div class="card-header">
                    <div class="col-12">
                        <div class="row">
                           
                            <div class="col-8">
                                <div class="row">
                                        <div class="col-2">
                                            {!! Form::label('search_data', 'Artist Name', array('class'=>'label-control')) !!}
                                        </div>
                                        <div class="col-5">
                                            {!! Form::open(['route'=>'zone.search','method'=>'GET']) !!}
                                                @include('filters.filter')
                                            {!! Form::close() !!}
                                        </div>
                                </div>
                               
                            </div>
                            <div class="col-4">
                                <a href="{{route('zone.create')}}">

                                    <button type="button" class="btn btn-link role-create"><i class="fa fa-plus-circle" aria-hidden="true"></i>&nbsp;&nbsp;Add Artist</button>
                                </a>
                            </div>
                        </div>
                    </div>
                  
                </div>

                <div class="card-body">

                        <!-- The List of Zone -->



                        <div>

                                @if(isset($zones))
                                <table class="table table-striped table-bordered task-table">
                                    <thead>
                                        <tr>
                                            <th>No.</th>
                                            <th>Artist Name</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($zones as $key=>$item)
                                        <tr>
                                            <td>{{$zones->firstItem()+$key}}</td>
                                            <td>{{$item->zone_name}}</td>
                                               
                                            <td>
                                                <div class="row">
                                                      
                                                        {{Form::open(['route'=>'zone.edit','method'=>'get'])}}
                                                            {{ Form::hidden('id',$item->id) }}
                                                                <button type="submit" class="btn btn-warning btn-sm action-btn"><i class="fas fa-pencil-alt"></i></button>
                                                        {{Form::close()}}
                                                    
                                                    
                                                        <button
                                                            data-toggle="modal" data-target="#deleteModal"
                                                            data-id="{{ $item->id }}"
                                                        
                                                            class="btn btn-danger btn-sm action-btn">
                                                            <i class="fa fa-trash"></i>

                                                        </button>
                                                </div>  

                                            </td>
                                            @include('layouts.delete',['id' => $item->id,'route'=>'zone.delete'])
                                        </tr>

                                        @endforeach
                                    </tbody>
                                   
                                </table>
                                <div style="float: right;">
                                    {!! Form::open(['route'=>'zone.delete','method'=>'delete','id'=>'delete_form']) !!}			
			                                {{ Form::hidden('id',0) }}
		                            {!! Form::close() !!}
                                    {{ $zones->appends(['search_data' => 'search_data'])->links() }} <!-- for paginate link -->
                                </div>
                               
                                @endif


                        </div>

                    </div>

                </div>
            </div>

@endsection
@section('adminlte_js')
<script>

    $(".togBtn").on('change', function() {
       
        var status = $(this).prop('checked') == true ? 1 : 0; 
        var media_id = $(this).data('id');
        
        $.ajax({
            type: "GET",
            dataType: "json",
            url: "{{ route('zone.status.change') }}",
            data: {'status': status, 'media_id': media_id},
            success: function(data){
               
                toastr.options.closeButton = true;
                toastr.options.closeMethod = 'fadeOut';
                toastr.options.fadeOut = 100;
                toastr.options.fadeIn = 100;
                toastr.options.closeDuration = 100;
                toastr.success(data.success);
                setInterval('location.reload()', 2000);
            }
        });
       
    });
</script>

@stop
