<?php $__env->startSection('content'); ?>

            <div class="content-header">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="text-dark">Update Album</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item">
                                <a href="#">Home</a>
                            </li>
                            <li class="breadcrumb-item active">
                                <a href="<?php echo e(route('album.index')); ?>">Album List</a>
                            </li>
                            <li class="breadcrumb-item">
                                 Update Album
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
            <div class="card">
              
                <?php echo Form::open(['route'=>'album.update','method'=>'POST','id'=>'create_album','enctype' => 'multipart/form-data']); ?>

                    <?php echo Form::hidden('id', $album->id); ?>

                    <div class="card-body">
                        <div class="col-12">
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group">
                                        <?php echo e(Form::label('artist_id','Artist',array('class'=>'control-label'))); ?>

                                        <?php echo e(Form::select('artist_id',$artists,$album->artist_id,array('class'=>'form-control select2bs4','placeholder'=>'<--Select Artist-->'))); ?>

                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="form-group">
                                        <?php echo e(Form::label('album_name_en','Album Name EN',array('class'=>'control-label'))); ?>

                                        <?php echo e(Form::text('album_name_en',$album->album_name_en,array('class'=>'form-control'))); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group">
                                        <?php echo e(Form::label('album_name_mm','Album Name MM',array('class'=>'control-label'))); ?>

                                        <?php echo e(Form::text('album_name_mm',$album->album_name_mm,array('class'=>'form-control'))); ?>

                                    </div>
                                </div>
                                <div class="col-6">
                                    <label for="imageInput">Album Image</label>
                                    <div class="row">
                                        <input class="col-md-6" name="album_image" type="file" id="imageInput"> 
                                        <div class="col-md-6">
                                            <img class="img-circle img-lg" id="preview"  src="<?php echo e($album->album_image); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <a href="<?php echo e(route('album.index')); ?>" class="btn btn-default">
                                <i class="fas fa-reply-all"></i> Back
                            </a>
                                   
                            <button type="submit" class="btn btn-primary">
                                <i class="far fa-save"></i> Update
                            </button>
                                 
                         
                        </div>
                    </div>
                <?php echo Form::close(); ?>

            </div>
            
       
<?php $__env->stopSection(); ?>
<?php $__env->startSection('adminlte_js'); ?>
<script>

     /* For Form Validation */
    jQuery( document ).ready(function( $ ) {

        $('#create_township').validate({ // initialize the plugin
                ignore: [],
                errorElement: "span",
                errorClass: "error-help-block",
                rules: {
                    name: {
                        required: true,
                        maxlength: 100
                    },
                    zone_id:{
                        required: true,
                    },
                    
                },
        });

    });
   
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\music-app\resources\views/albums/edit.blade.php ENDPATH**/ ?>