<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Album extends Model
{
    protected $table = 'albums';
    protected $fillable = ['album_name_en','album_name_mm','artist_id','album_image'];

    /**
     * artist
     *
     * @return void
     */
    public function artist()
    {
        return $this->belongsTo('App\Artist', 'artist_id');

    }
    
    public function songs()
    {
        return $this->hasMany('App\Song');
    }
}
