<?php

namespace App\Http\Controllers\Admin\Zone;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Repositories\Admin\ZoneRepository;

class ZoneController extends Controller
{
    public function __construct(ZoneRepository $zoneRepo)
    {
        $this->zoneRepo = $zoneRepo;
        $this->perPage = 15;
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $zones = $this->zoneRepo->getPaginated($this->perPage);
        return view('zones.index', compact('zones'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    
        return view('zones.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data=[];
        $data['zone_name'] = $request->zone_name;
        $data['url'] = $request->url;
        $data['fetch_name'] = $request->fetch_name;
        $data['fetch_status'] = ($request->fetch_status == null ? 0 : $request->fetch_status);
        try {
            $this->zoneRepo->create($data);
        } catch (\Exception $e) {
            Alert::error('Error', $e->getMessage());
            return redirect()->back()->withInput();
        }
        return redirect()->route('zone.index')->with(['status'=>'Zone was successful added!']);
    }

    /**
     * Display the specified resource.
     *
     *  @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request)
    {
        $zone = $this->zoneRepo->getById($request->id);
        return view('zones.edit', compact('zone'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $data=[];
        $data['id'] = $request->id;
        $data['zone_name'] = $request->zone_name;
        $data['url'] = $request->url;
        $data['fetch_name'] = $request->fetch_name;
        $data['fetch_status'] = ($request->fetch_status == null ? 0 : $request->fetch_status);
       
        try {
            $this->zoneRepo->update($data, $data['id']);
        } catch (\Exception $e) {
            Alert::error('Error', $e->getMessage());
            return redirect()->back()->withInput();
        }
        return redirect()->route('zone.index')->with(['status'=>'Zone was successful updated!']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $id=$request->input('id');
        try {
            $zone = $this->zoneRepo->getById($request->id);
            $this->zoneRepo->delete($id);
        } catch (\Exception $e) {
            Alert::error('Error', $e->getMessage());
            return redirect()->back()->withInput();
        }
      
        return redirect()->route('zone.index')->with(['error'=>'Zone was successful deleted!']);
    }
    /**
     * Status active and inactive
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function statusChange(Request $request)
    {
        $this->zoneRepo->statusChange($request->status, $request->media_id);
        return response()->json(['success'=>'Status Change is Successful!!']);
    }
    /**
     *Searching by zone name
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function search(Request $request)
    {
        $search_data = $request->search_data;
        $zones = $this->zoneRepo->filter($request->search_data);
        return view('zones.index', compact('zones', 'search_data'));
    }
}
