<?php
namespace App\Repositories\Admin;

abstract class BaseRepository
{
    protected $model;

    public function __construct(\Model $model)
    {
        $this->model = $model;
    }
    public function create(array $data)
    {
        return $this->model->create($data);
    }
    public function getAll()
    {
        return $this->model->orderBy('id','DESC')->get();
    }
    public function getById($id)
    {
        return $this->model->findOrFail($id);
    }
    public function update(array $data)
    {
        $model = $this->getById($data['id']);
        $model->fill($data);
        return $model->push();
    }
    
    public function delete($id)
    {
        return $this->model->destroy($id);
    }

    public function getPaginated($page)
    {
        return $this->model->orderBy('id','DESC')->paginate($page);
    }
}

?>
