<?php
namespace App\Repositories\Admin;
use App\Song;
use App\Artist;
use App\Album;

Class SongRepository extends BaseRepository
{
    protected $model;

	public function __construct(Song $model)
	{
		$this->model = $model;
	}
	public function createSong($data)
    {
        return $this->model->create($data);
	}
	public function getArtist()
    {
        $data=[];
        $artists = Artist::select('id','name_en')->orderby('id','DESC')->get();
        foreach ($artists as $key => $value) {
            $data[$value->id]=$value->name_en;
        }
        return $data;
	}
    public function getAlbum()
    {
        $data=[];
        $albums = Album::select('id','album_name_en')->orderby('id','DESC')->get();
        foreach ($albums as $key => $value) {
            $data[$value->id]=$value->album_name_en;
        }
        return $data;
	}
	public function updateSong($id,$data)
    {

    	return $this->model->where('id',$id)->update($data);

    }
    
}

?>
