<?php
namespace App\Repositories\Admin;

abstract class BaseRepository
{
    protected $msg, $http_status, $success_status, $fail_status;

    public function __construct(\Model $model)
    {
        $this->model = $model;
        $this->success_status = 1;
        $this->fail_status = 0;

    }
    public function successResponse($result, $msg)
    {
        return response()->json([
            "result"=>$result,
            "status_code"=>$this->success_status,
            "message"=>$msg
        ]);
    }
    
    public function failResponse($result, $msg)
    {
        return response()->json([
            "result"=>$result,
            "status_code"=>$this->fail_status,
            "message"=>$msg
        ]);
    }
    

   
}

?>
