@extends('adminlte::page')
@section('plugins.Sweetalert2', true)
@section('content')
        <div class="content-header">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="text-dark">Role List</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item">
                            <a href="#">Home</a>
                        </li>
                        <li class="breadcrumb-item active">
                            <a href="{{route('role.index')}}">Role List</a>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        @if (session('status'))
                <div class="alert alert-success" role="alert" id="dialog">
                    {{ session('status') }}
                </div>
        @endif
        @if (session('error'))
                <div class="alert alert-danger" role="alert" id="errordialog">
                    {{ session('error') }}
                </div>
        @endif
        <div class="card">
                <div class="card-header">
                    @can('create_role')
                        <a href="{{route('role.create')}}">

                            <button type="button" class="btn btn-link role-create"><i class="fa fa-plus-circle" aria-hidden="true"></i> Add Role</button>
                        </a>
                    @endcan
                </div>

                <div class="card-body">
                        <!-- The List of Roles -->
                        <div>

                                @if(isset($roles))
                                <table class="table table-striped table-bordered task-table">
                                    <thead>
                                        <tr>
                                            <th>No.</th>
                                            <th>Name</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($roles as $key=>$item)
                                        <tr>
                                            <td>{{$roles->firstItem()+$key}}</td>
                                            <td>{{$item->name}}</td>
                                            <td>
                                                <div class="row">
                                                 
                                                    {!! Form::open(['route'=>'role.edit','method'=>'get']) !!}
                                                        {{ Form::hidden('id',$item->id) }}
                                                        <button class="btn btn-info btn-sm action-btn"><i class="fas fa-pencil-alt"></i> Edit</button>

                                                    {!! Form::close() !!}

                                                    <button
                                                        data-toggle="modal" data-target="#deleteModal"
                                                        data-id="{{ $item->id }}"
                                                            
                                                        class="btn btn-danger btn-sm action-btn">
                                                        <i class="fa fa-trash"> Delete</i>

                                                    </button>
                                                
                                                   
                                                </div>
                                                
                                            </td>
                                            @include('layouts.delete',['id' => $item->id,'route'=>'role.delete'])
                                        </tr>

                                        @endforeach
                                    </tbody>
                                </table>
                                <div style="float: right;">
                                    {!! Form::open(['route'=>'role.delete','method'=>'delete','id'=>'delete_form']) !!}		
                                        {{ Form::hidden('id',0) }}
                                    {!! Form::close() !!}
                                    {{ $roles->links() }} <!-- for paginate link -->
                                </div>


                                @endif
                        </div>

                    </div>

                </div>
        </div>
       

@endsection
