@extends('adminlte::page')
@section('content')

            <div class="content-header">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="text-dark"> Song Details</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item">
                                <a href="#">Home</a>
                            </li>
                            <li class="breadcrumb-item active">
                                <a href="{{route('song.index')}}">Song List</a>
                            </li>
                            <li class="breadcrumb-item active">
                                Song Details
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
            <div class="card">
              
                {!! Form::open(['route'=>'song.update','method'=>'POST','id'=>'create_township']) !!}
                    {!! Form::hidden('id', $song->id) !!}
                    <div class="card-body">
                        <div class="col-12">
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group">
                                        <label for="artists">Artist</label>
                                        <p>{{ $song->artist->name_en}}</p>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="form-group">
                                        <label for="song_name_en">Song Name EN</label>
                                        <p>{{$song->song_name_en }}</p>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                            <div class="col-6">
                                <div class="form-group">
                                    <label for="albums">Album</label>
                                   <p>{{ $song->album->album_name_en}}</p>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-group">
                                    <label for="song_name_mm">Song Name MM</label>
                                    <p>{{$song->song_name_mm }}</p> 
                                </div>
                            </div>
                           
                        </div>
                        <div class="row">
                            <div class="col-6">
                                <label for="imageInput">Chord Image</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <img class="img-rounded  img-lg" id="preview"  src="{{$song->chord_image}}">
                                    </div>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="is_popular" value="1" @if($song->is_popular == 1) checked @endif>
                                        <label class="form-check-label">Is Popular</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-3">
                           
                                <div class="form-group">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="is_publish" value="1" @if($song->is_publish == 1) checked @endif>
                                        <label class="form-check-label">Is Publish</label>
                                    </div>
                                </div>
                            </div>
                           
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-12">
                                <a href="{{route('song.index')}}" class="btn btn-default">
                                    <i class="fas fa-reply-all"></i> Back
                                </a>
                                    
                            
                            </div>
                        </div>
                        </div>
                       
                    </div>
                {!! Form::close() !!}
            </div>
            
       
@stop
@section('adminlte_js')
<script>

     /* For Form Validation */
    jQuery( document ).ready(function( $ ) {

        $('#create_township').validate({ // initialize the plugin
                ignore: [],
                errorElement: "span",
                errorClass: "error-help-block",
                rules: {
                    name: {
                        required: true,
                        maxlength: 100
                    },
                    zone_id:{
                        required: true,
                    },
                    
                },
        });

    });
   
</script>
@stop