@extends('adminlte::page')
@section('content')
    <div class="content-header">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="text-dark">Song List</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">
                        <a href="#">Home</a>
                    </li>
                    <li class="breadcrumb-item active">
                        <a href="{{ route('township.index') }}">Song List</a>
                    </li>
                </ol>
            </div>
        </div>
    </div>
    @if (session('status'))
        <div class="alert alert-success" role="alert" id="dialog">
            {{ session('status') }}
        </div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger" role="alert" id="errordialog">
            {{ session('error') }}
        </div>
    @endif

    <div class="card">
        <div class="card-header">
            <div class="col-12">
                <div class="row">

                    <div class="col-8">
                        <div class="row">
                            <div class="col-2">
                                {!! Form::label('search_data', 'Song Name', ['class' => 'label-control']) !!}
                            </div>
                            <div class="col-5">
                                {!! Form::open(['route' => 'township.search', 'method' => 'GET']) !!}
                                @include('filters.filter')
                                {!! Form::close() !!}
                            </div>
                        </div>

                    </div>
                    <div class="col-4">
                        <a href="{{ route('township.create') }}">

                            <button type="button" class="btn btn-link role-create"><i class="fa fa-plus-circle"
                                    aria-hidden="true"></i>&nbsp;&nbsp;Add Song</button>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-body">

            <!-- The List of Township -->

            <div>

                @if (isset($township))
                    <table class="table table-striped table-bordered task-table">
                        <thead>
                            <tr>
                                <th>No.</th>
                                <th>Song Name</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($township as $key => $item)

                                <tr>
                                    <td>{{ $township->firstItem() + $key }}</td>
                                    <td>{{ $item->name }}</td>

                                    <td>
                                        <div class="row">

                                            {{ Form::open(['route' => 'township.edit', 'method' => 'get']) }}
                                            {{ Form::hidden('id', $item->id) }}
                                            <button type="submit" class="btn btn-warning btn-sm action-btn"><i
                                                    class="fas fa-pencil-alt"></i></button>
                                            {{ Form::close() }}
                                            <button data-toggle="modal" data-target="#deleteModal" data-id="{{ $item->id }}"
                                                class="btn btn-danger btn-sm action-btn">
                                                <i class="fa fa-trash"></i>

                                            </button>
                                        </div>

                                    </td>
                                    @include('layouts.delete',['id' => $item->id,'route'=>'township.delete'])
                                </tr>

                            @endforeach
                        </tbody>

                    </table>
                    <div style="float: right;">
                        {!! Form::open(['route' => 'township.delete', 'method' => 'delete', 'id' => 'delete_form']) !!}
                        {{ Form::hidden('id', 0) }}
                        {!! Form::close() !!}
                        {{ $township->appends(['search_data' => 'search_data'])->links() }} <!-- for paginate link -->
                    </div>

                @endif


            </div>

        </div>

    </div>
    </div>

@endsection
@section('adminlte_js')

@stop
