@extends('adminlte::page')
@section('content')
        <div class="content-header">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="text-dark">Update Zone</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item">
                            <a href="#">Home</a>
                        </li>
                        <li class="breadcrumb-item active">
                            <a href="{{route('zone.index')}}">Zone List</a>
                        </li>
                        <li class="breadcrumb-item active">
                            <a href="{{url('control-panel/zone/edit?id='.$zone->id)}}">Update Zone</a>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
            <div class="card">
               
                {!! Form::open(['route'=>'zone.update','method'=>'POST','id'=>'create_zone']) !!}
                    {{Form::hidden('id',$zone->id)}}
                    <div class="card-body">
                        @if (session('status'))
                            <div class="alert alert-success" role="alert">
                                {{ session('status') }}
                            </div>
                        @endif
                        <!-- The Form to Add a New Zone -->
                        <div class="col-12">
                            <div class="row">
                                <div class="col-6">
                                    <div class="form-group">
                                        {{ Form::label('zone_name','Zone Name',array('class'=>'control-label'))}}
                                        {{ Form::text('zone_name',$zone->zone_name,array('class'=>'form-control','placeholder'=>'Zone Name')) }}
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="form-group">
                                        {{ Form::label('url','URL',array('class'=>'control-label'))}}
                                        {{ Form::text('url',$zone->url,array('class'=>'form-control','placeholder'=>'URL')) }}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="row">
                               
                                <div class="col-6">
                                    <div class="form-group">
                                        {{ Form::label('fetch_name','Fetch Type',array('class'=>'control-label'))}}
                                         <select name="fetch_name" class="form-control select2bs4">

                                             <option value="">
                                                 <-- Select Fetch Type -->
                                             </option>
                                             <option value="type1" {{($zone->fetch_name ==='type1') ? 'selected' : ''}}>type1</option>
                                             <option value="type2" {{($zone->fetch_name ==='type2') ? 'selected' : ''}}>type2</option>
                                             <option value="type3" {{($zone->fetch_name ==='type3') ? 'selected' : ''}}>type3</option>
                                             <option value="type4" {{($zone->fetch_name ==='type4') ? 'selected' : ''}}>type4</option>
                                             <option value="type5" {{($zone->fetch_name ==='type5') ? 'selected' : ''}}>type5</option>

                                         </select>

                                    </div>
                                </div>

                                <div class="col-6">
                                    <div class="form-group">
                                       

                                        <label class="switch">
                                            Fetch Status
                                            @if($zone->fetch_status == 1)
                                                <input type="checkbox" id="togBtn" value="{{$zone->fetch_status}}" name="fetch_status" 
                                                checked=""  data-id="{{$zone->id}}">
                                            @else
                                                <input type="checkbox" id="togBtn" value="{{$zone->fetch_status}}" name="fetch_status" data-id="{{$zone->id}}">
                                            @endif
                                            <span class="slider round"></span>
                                        </label>
                                        
                                    </div>
                                
                                </div>
                                
                            </div>
                        </div>
                        <div class="col-12">
                            <a href="{{route('zone.index')}}" class="btn btn-default">
                                <i class="fas fa-reply-all"></i> Back
                            </a>

                            <button type="submit" class="btn btn-primary">
                                <i class="far fa-save"></i> Update
                            </button>
                        </div>
                    </div>
                {!! Form::close() !!}
            </div>
       
@endsection
@section('adminlte_js')
<script>

    /* For Form VAlidation */
    jQuery( document ).ready(function( $ ) {

        $('#create_zone').validate({ // initialize the plugin
                ignore: [],
                errorElement: "span",
                errorClass: "error-help-block",
                rules: {
                    zone_name: {
                        required: true,
                        maxlength: 100
                    },
                    url:{
                        required: true,
                    },
                    
                    fetch_name: {
                        required: true,
                    }
                },
        });

    });
    /* For Status btn active & inactive */
    $("#togBtn").on('change', function() {
       
        if ($(this).is(':checked')) {
            $(this).val('1');

        }
        else {
            $(this).val('0');
        }
    });
</script>
@stop